package ru.yandex.webmaster3.viewer.http.mobile;

import lombok.ToString;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author avhaliullin
 */
@ToString
public class StartMobileAuditRequest extends AbstractUserVerifiedHostRequest {
    private String url;
    private int width = 320;
    private int height = 460;

    public int getWidth() {
        return width;
    }

    @Description("Ширина скриншота")
    @RequestQueryProperty
    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    @Description("Высота скриншота")
    @RequestQueryProperty
    public void setHeight(int height) {
        this.height = height;
    }

    public String getUrl() {
        return url;
    }

    @Description("URL для проверки")
    @RequestQueryProperty(required = true)
    public void setUrl(String url) {
        this.url = url;
    }
}
