package ru.yandex.webmaster3.viewer.http.mobile;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.response.URLPrettySerializer;

import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public abstract class StartMobileAuditResponse implements ActionResponse {
    public static class NormalResponse extends StartMobileAuditResponse implements ActionResponse.NormalResponse {
        private final URL url;
        private final UUID requestId;

        public NormalResponse(URL url, UUID requestId) {
            this.url = url;
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }

        @Description("URL для проверки")
        @JsonSerialize(using = URLPrettySerializer.class)
        public URL getUrl() {
            return url;
        }
    }

    public enum ErrorTypes {
        START_MOBILE_AUDIT__INVALID_URL,
        START_MOBILE_AUDIT__URL_FROM_ANOTHER_HOST,
        START_MOBILE_AUDIT__HOST_LIMIT_REACHED,
    }

    public static abstract class AbstractErrorResponse extends StartMobileAuditResponse implements ActionResponse.ErrorResponse {
        private final ErrorTypes errorType;

        public AbstractErrorResponse(ErrorTypes errorType) {
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }
    }

    @Description("Передан невалидный URL")
    public static class InvalidUrlResponse extends AbstractErrorResponse {
        public InvalidUrlResponse() {
            super(ErrorTypes.START_MOBILE_AUDIT__INVALID_URL);
        }
    }

    @Description("Переданный URL не относится к текущему хосту")
    public static class UrlFromAnotherHostResponse extends AbstractErrorResponse {
        public UrlFromAnotherHostResponse() {
            super(ErrorTypes.START_MOBILE_AUDIT__URL_FROM_ANOTHER_HOST);
        }
    }

    @Description("Дневной лимит запросов для хоста исчерпан")
    public static class HostLimitReachedResponse extends AbstractErrorResponse {
        public HostLimitReachedResponse() {
            super(ErrorTypes.START_MOBILE_AUDIT__HOST_LIMIT_REACHED);
        }
    }
}
