package ru.yandex.webmaster3.viewer.http.news;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.news.MassMediaService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

/**
 * ishalaru
 * 17.11.2020
 **/
@Slf4j
@Component("/news/loadMassMediaInfo")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@ReadAction
@Category("news")
public class LoadMassMediaInfoAction extends AbstractUserVerifiedHostAction<LoadMassMediaInfoAction.Request, LoadMassMediaInfoAction.Response> {
    private final MassMediaService massMediaService;

    @Override
    public Response process(Request request) {
        final Map<Long, String> longStringMap = massMediaService.loadDict(request.template, request.limit);
        final Set<Long> selectedMassMedia = Optional.ofNullable(massMediaService.loadTrustedMassMedia(request.getHostId()))
                .orElse(Set.of());
        final List<Media> massMedia = longStringMap.entrySet().stream()
                .map(e -> new Media(e.getKey(), e.getValue(), selectedMassMedia.contains(e.getKey())))
                .collect(Collectors.toList());
        return new Response(massMedia);
    }


    @Data
    public static class Request extends UsersVerifiedHostRequest {
        @Setter(onMethod_ = {@Description("Шаблон для поиска"), @RequestQueryProperty(required = false)})
        private String template;
        @Setter(onMethod_ = {@Description("Лимит на кол-во ответов, максимум 50, по умолчанию 20"), @RequestPostProperty(required = false)})
        private Integer limit = 20;
    }

    @Value
    public static class Response implements ActionResponse, ActionResponse.NormalResponse {
        @Description("Все доступные средсва массовой информации с пересечением о том выбрали их или нет.")
        List<Media> massMedia;
    }

    @Value
    public static class Media {
        Long id;
        String name;
        Boolean selected;
    }
}
