package ru.yandex.webmaster3.viewer.http.news;

import java.util.List;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.news.MassMediaService;
import ru.yandex.webmaster3.storage.news.Media;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

/**
 * ishalaru
 * 17.11.2020
 **/
@Slf4j
@Component("/news/saveMassMediaInfo")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@WriteAction
@Category("news")
public class SaveMassMediaInfoAction extends AbstractUserVerifiedHostAction<SaveMassMediaInfoAction.Request, SaveMassMediaInfoAction.Response> {
    private final MassMediaService massMediaService;

    @Override
    public Response process(Request request) {
        massMediaService.saveTrustedMassMedia(request.getHostId(), request.trustedMassMedia);
        return new Response();
    }

    public static class Request extends UsersVerifiedHostRequest {

        List<Media> trustedMassMedia;

        @RequestQueryProperty(required = true)
        public void setTrustedMassMedia(List<Media> trustedMassMedia) {
            this.trustedMassMedia = trustedMassMedia;
        }
    }

    @Value
    public static class Response implements ActionResponse, ActionResponse.NormalResponse {
    }

}
