package ru.yandex.webmaster3.viewer.http.niche;

import com.google.common.hash.Hasher;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.niche.QuerySource;
import ru.yandex.webmaster3.storage.niche.download.NicheQueriesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * Created by Oleg Bazdyrev on 27/07/2021.
 */
@ReadAction
@Category("niche")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/niche/queries/download")
public class DownloadNicheQueriesAction extends DownloadAction2<DownloadNicheQueriesAction.Request> {

    @Override
    protected MdsExportDescriptor makeRequest(Request request) {
        return new NicheQueriesMdsExportDescriptor(request.getHostId(), request.dateFrom, request.dateTo, request.deviceType, request.regionId, request.source);
    }

    @Override
    protected void customizeHash(Hasher h, Request request) {
        h.putLong(request.dateFrom.getMillis());
        h.putLong(request.dateTo.getMillis());
        h.putInt(request.deviceType.value());
        if (request.regionId != null) {
            for (Integer r : request.regionId) {
                h.putInt(r);
            }
        }
        h.putInt(request.source.value());
    }

    public enum NicheQueriesExportField {
    }

    public static class NicheQueriesExportFilter extends AbstractFilter<NicheQueriesExportField> {
        public NicheQueriesExportFilter(NicheQueriesExportField indicator, Operation operation, String value) {
            super(indicator, operation, value);
        }
    }

    public static final class Request extends DownloadRequest<NicheQueriesExportField, NicheQueriesExportFilter> {
        @Setter(onMethod_ = {@Description("Начало периода"), @RequestQueryProperty(required = true)})
        DateTime dateFrom;
        @Setter(onMethod_ = {@Description("Конец периода"), @RequestQueryProperty(required = true)})
        DateTime dateTo;
        @Setter(onMethod_ = {@Description("Тип устройства"), @RequestQueryProperty(required = true)})
        DeviceType deviceType;
        @Setter(onMethod_ = {@Description("Регионы"), @RequestQueryProperty(required = false)})
        Integer[] regionId;
        @Setter(onMethod_ = {@Description("Источник query"), @RequestQueryProperty(required = true)})
        QuerySource source;
    }

}
