package ru.yandex.webmaster3.viewer.http.niche2;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.searchquery.QueryGroupService;
import ru.yandex.webmaster3.storage.searchquery.dao.QueriesGroupsRelationYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

@ReadAction
@Category("niche2")
@Component("/niche2/query_groups")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetNiche2QueryGroupAction extends AbstractUserVerifiedHostAction<GetNiche2QueryGroupAction.Request,
        GetNiche2QueryGroupAction.Response> {
    private final QueryGroupService queryGroupService;
    private final QueriesGroupsRelationYDao queriesGroupsRelationYDao;

    @Override
    public Response process(Request request) {
        var groups = queryGroupService.listGroups(request.getHostId())
                .stream()
                .filter(x -> queriesGroupsRelationYDao.hasQueries(x.getQueryGroupId()))
                .map(x -> new GroupInfo(x.getName(), x.getGroupId().toString()))
                .collect(Collectors.toList());
        groups.add(new GroupInfo("Ниша сайта", "NICHE"));
        groups.add(new GroupInfo("Новые рынки", "NEW_MARKETS"));
        return new Response(groups);
    }

    public static final class Request extends UsersVerifiedHostRequest {
    }

    @Value
    public static class GroupInfo {
        String name;
        String groupId;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        @Description("Список статических запросных групп")
        List<GroupInfo> queryGroups;
    }
}
