package ru.yandex.webmaster3.viewer.http.niche2;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.niche2.Niche2QueriesCHDao;
import ru.yandex.webmaster3.storage.niche2.Niche2QueriesCHDao.ProblemEnum;
import ru.yandex.webmaster3.storage.niche2.Niche2QueriesCHDao.QueryReportRecord;
import ru.yandex.webmaster3.storage.niche2.filters.FilterEntity;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

@ReadAction
@Category("niche2")
@Component("/niche2/query_list")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Slf4j
public class GetNiche2QueryListAction extends AbstractUserVerifiedHostAction<GetNiche2QueryListAction.Request,
        GetNiche2QueryListAction.Response> {
    private final Niche2QueriesCHDao niche2QueriesCHDao;

    @Override
    public Response process(Request request) {
        List<FilterEntity> filters = request.filters == null? List.of() : request.filters
                .stream()
                .map(FilterEntity::buildTrimmed)
                .collect(Collectors.toList());
        var queries = niche2QueriesCHDao.getQueries(
                request.getHostId(),
                request.groupId,
                filters,
                request.problemFilter,
                request.p,
                request.pSize);
        var count = niche2QueriesCHDao.getQueriesCount(
                request.getHostId(),
                request.groupId,
                filters,
                request.problemFilter);
        return new Response(queries, count);
    }

    public static class Request extends UsersVerifiedHostRequest {
        @Setter(onMethod_ = {@Description("Номер страницы"), @RequestQueryProperty(required = true)})
        int p;
        @Setter(onMethod_ = {@Description("Кол-во позиций на 1 странице"), @RequestQueryProperty(required = true)})
        int pSize;
        @Setter(onMethod_ = {@Description("Идентификатор группы"), @RequestQueryProperty(required = true)})
        String groupId;
        @Setter(onMethod_ = {@Description("Фильтры"), @RequestQueryProperty})
        List<FilterEntity> filters;
        @Setter(onMethod_ = {@Description("Фильтр по проблемам"), @RequestQueryProperty})
        List<ProblemEnum> problemFilter;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        @Description("Список запросов для данного хоста")
        List<QueryReportRecord> queryReport;
        @Description("Количество запросов")
        Integer totalCount;
    }
}
