package ru.yandex.webmaster3.viewer.http.niche2;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.regions.RegionUtils;
import ru.yandex.webmaster3.core.regions.W3RegionsTreeService;
import ru.yandex.webmaster3.storage.niche2.Niche2RivalsCHDao;
import ru.yandex.webmaster3.viewer.http.searchquery.regions.RegionView;
import ru.yandex.webmaster3.viewer.http.searchquery.regions.RegionsTreeBuilder;
import ru.yandex.webmaster3.viewer.regions.SearchQueryRegionsIndexService;

@ReadAction
@Category("niche2")
@Component("/niche2/getRegions")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Slf4j
public class GetNiche2RegionsAction extends Action<GetNiche2RegionsAction.Request, GetNiche2RegionsAction.Response> {

    private final SearchQueryRegionsIndexService searchQueryRegionsIndexService;
    private final W3RegionsTreeService w3regionsTreeService;
    private final Niche2RivalsCHDao niche2RivalsCHDao;

    @Override
    public Response process(Request request) throws WebmasterException {
        String filter = request.filter;
        if (filter != null) {
            filter = filter.trim().toLowerCase();
            if (StringUtils.isEmpty(filter)) {
                filter = null;
            }
        }
        RegionsTreeBuilder builder = new RegionsTreeBuilder(searchQueryRegionsIndexService, w3regionsTreeService,
                filter, request.regionId);
        niche2RivalsCHDao
                .getRegions(request.hostId, request.groupId)
                .forEach(builder::addRegion);
        return new Response(builder.build());
    }

    public static class Request implements ActionRequest {
        @Setter(onMethod_ = {@Description("Host"), @RequestQueryProperty(required = true)})
        WebmasterHostId hostId;
        @Setter(onMethod_ = {@Description("Идентификатор региона"), @RequestQueryProperty(required = false)})
        int regionId = RegionUtils.WHOLE_WORLD_REGION.getId();
        @Setter(onMethod_ = {@Description("Фильтр поиска"), @RequestQueryProperty(required = false)})
        String filter;
        @Setter(onMethod_ = {@Description("Идентификатор группы"), @RequestQueryProperty(required = false)})
        String groupId;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        List<RegionView> regions;
    }
}
