package ru.yandex.webmaster3.viewer.http.originaltext;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.originaltext.OriginalText;

/**
 * @author aherman
 */
public abstract class AddOriginalTextResponse implements ActionResponse {
    public static class NormalResponse extends AddOriginalTextResponse implements ActionResponse.NormalResponse {
        private final OriginalText text;

        public NormalResponse(OriginalText text) {
            this.text = text;
        }

        public OriginalText getText() {
            return text;
        }
    }

    public enum Error {
        ADD_ORIGINAL_TEXT__TEXT_TOO_SHORT,
        ADD_ORIGINAL_TEXT__TEXT_TOO_LONG,
        ADD_ORIGINAL_TEXT__QUOTA_EXCEEDED,
        ADD_ORIGINAL_TEXT__TEXT_ALREADY_ADDED,
    }

    public static class TextTooShortError extends AddOriginalTextResponse implements ActionResponse.ErrorResponse {
        @Override public Enum<?> getCode() {return Error.ADD_ORIGINAL_TEXT__TEXT_TOO_SHORT;}
        @Override public String getMessage() {return "Text too short";}
    }

    public static class TextTooLongError extends AddOriginalTextResponse implements ActionResponse.ErrorResponse {
        @Override public Enum<?> getCode() {return Error.ADD_ORIGINAL_TEXT__TEXT_TOO_LONG;}
        @Override public String getMessage() {return "Text too long";}
    }

    public static class TextAlreadyAddedError extends AddOriginalTextResponse implements ActionResponse.ErrorResponse {
        @Override public Enum<?> getCode() {return Error.ADD_ORIGINAL_TEXT__TEXT_ALREADY_ADDED;}
        @Override public String getMessage() {return "Text already added";}
    }

    public static class QuotaExceededError extends AddOriginalTextResponse implements ActionResponse.ErrorResponse {
        private final int textQuota;

        public QuotaExceededError(int textQuota) {
            this.textQuota = textQuota;
        }

        public int getTextQuota() {
            return textQuota;
        }

        @Override public Enum<?> getCode() {return Error.ADD_ORIGINAL_TEXT__QUOTA_EXCEEDED;}
        @Override public String getMessage() {return "Daily quota exceeded";}
    }
}
