package ru.yandex.webmaster3.viewer.http.originaltext;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.originaltext.OriginalTextService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@WriteAction
@Category("originaltext")
public class DeleteOriginalTextAction extends AbstractUserVerifiedHostAction<DeleteOriginalTextRequest, DeleteOriginalTextResponse> {
    private OriginalTextService originalTextService;

    @Override
    public DeleteOriginalTextResponse process(DeleteOriginalTextRequest request) {
        originalTextService.deleteText(request.getHostId(), request.getTextId());
        return new DeleteOriginalTextResponse.NormalResponse();
    }

    @Required
    public void setOriginalTextService(OriginalTextService originalTextService) {
        this.originalTextService = originalTextService;
    }
}
