package ru.yandex.webmaster3.viewer.http.originaltext;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.originaltext.OriginalTextService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@ReadAction
@Category("originaltext")
public class GetOriginalTextLimitsAction extends
        AbstractUserVerifiedHostAction<GetOriginalTextLimitsRequest, GetOriginalTextLimitsResponse>
{
    private OriginalTextService originalTextService;

    @Override
    public GetOriginalTextLimitsResponse process(GetOriginalTextLimitsRequest request) {
        return new GetOriginalTextLimitsResponse.NormalResponse(0, 0, 0, 0);
    }

    @Required
    public void setOriginalTextService(OriginalTextService originalTextService) {
        this.originalTextService = originalTextService;
    }
}
