package ru.yandex.webmaster3.viewer.http.originaltext;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class GetOriginalTextLimitsResponse implements ActionResponse {

    public static class NormalResponse extends GetOriginalTextLimitsResponse implements ActionResponse.NormalResponse {
        private final int minTextLength;
        private final int maxTextLength;
        private final int textQuota;
        private final int textQuotaUsed;

        public NormalResponse(int minTextLength, int maxTextLength, int textQuota, int textQuotaUsed) {
            this.minTextLength = minTextLength;
            this.maxTextLength = maxTextLength;
            this.textQuotaUsed = textQuotaUsed;
            this.textQuota = textQuota;
        }

        public int getMinTextLength() {
            return minTextLength;
        }

        public int getMaxTextLength() {
            return maxTextLength;
        }

        public int getTextQuotaUsed() {
            return textQuotaUsed;
        }

        public int getTextQuota() {
            return textQuota;
        }
    }
}
