package ru.yandex.webmaster3.viewer.http.originaltext;

import java.util.Collections;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.originaltext.OriginalTextService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@ReadAction
@Category("originaltext")
public class ListOriginalTextsAction extends
        AbstractUserVerifiedHostAction<ListOriginalTextsRequest, ListOriginalTextsResponse>
{
    private OriginalTextService originalTextService;

    @Override
    public ListOriginalTextsResponse process(ListOriginalTextsRequest request) {
        return new ListOriginalTextsResponse.NormalResponse(0, Collections.emptyList());
    }

    @Required
    public void setOriginalTextService(OriginalTextService originalTextService) {
        this.originalTextService = originalTextService;
    }
}
