package ru.yandex.webmaster3.viewer.http.originaltext;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.originaltext.OriginalText;

/**
 * @author aherman
 */
public abstract class ListOriginalTextsResponse implements ActionResponse {
    public static class NormalResponse extends ListOriginalTextsResponse implements ActionResponse.NormalResponse {
        private final int totalTexts;
        private final List<OriginalText> texts;

        public NormalResponse(int totalTexts, List<OriginalText> texts) {
            this.totalTexts = totalTexts;
            this.texts = texts;
        }

        public int getTotalTexts() {
            return totalTexts;
        }

        public List<OriginalText> getTexts() {
            return texts;
        }
    }
}
