package ru.yandex.webmaster3.viewer.http.originaltext.proxy;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.originaltext.DirectOriginalTextService;
import ru.yandex.webmaster3.storage.originaltext.OriginalsResponse;

/**
 * @author avhaliullin
 */
@WriteAction
@Category("originaltext")
public class ProxyAddTextAction extends Action<ProxyAddTextAction.Req, ProxyAddTextAction.Res> {
    private DirectOriginalTextService directOriginalTextService;

    @Override
    public Res process(Req request) throws WebmasterException {
        return new Res(directOriginalTextService.addText(request.hostId, request.text));
    }

    public static class Req implements ActionRequest {
        private WebmasterHostId hostId;
        private String text;

        @RequestPostProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }

        @RequestPostProperty(required = true)
        public void setText(String text) {
            this.text = text;
        }
    }

    public static class Res implements ActionResponse {
        private final OriginalsResponse data;

        public Res(OriginalsResponse data) {
            this.data = data;
        }

        public OriginalsResponse getData() {
            return data;
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    @Required
    public void setDirectOriginalTextService(DirectOriginalTextService directOriginalTextService) {
        this.directOriginalTextService = directOriginalTextService;
    }
}
