package ru.yandex.webmaster3.viewer.http.originaltext.proxy;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.originaltext.DirectOriginalTextService;

/**
 * @author avhaliullin
 */
@WriteAction
@Category("originaltext")
public class ProxyDeleteTextAction extends Action<ProxyDeleteTextAction.Req, ProxyDeleteTextAction.Res> {
    private DirectOriginalTextService directOriginalTextService;

    @Override
    public Res process(Req request) throws WebmasterException {
        directOriginalTextService.deleteText(request.hostId, request.textId);
        return new Res();
    }

    public static class Req implements ActionRequest {
        private WebmasterHostId hostId;
        private String textId;

        @RequestPostProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }

        @RequestPostProperty(required = true)
        public void setTextId(String textId) {
            this.textId = textId;
        }
    }

    public static class Res implements ActionResponse {
        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    @Required
    public void setDirectOriginalTextService(DirectOriginalTextService directOriginalTextService) {
        this.directOriginalTextService = directOriginalTextService;
    }
}
