package ru.yandex.webmaster3.viewer.http.originaltext.proxy;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.originaltext.DirectOriginalTextService;
import ru.yandex.webmaster3.storage.originaltext.OriginalTextLimits;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("originaltext")
public class ProxyLimitsAction extends Action<ProxyLimitsAction.Req, ProxyLimitsAction.Res> {
    private DirectOriginalTextService directOriginalTextService;

    @Override
    public Res process(Req request) throws WebmasterException {
        return new Res(directOriginalTextService.getLimits(request.hostId));
    }

    public static class Req implements ActionRequest {
        private WebmasterHostId hostId;

        @RequestPostProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }
    }

    public static class Res implements ActionResponse {
        private final OriginalTextLimits data;

        public Res(OriginalTextLimits data) {
            this.data = data;
        }

        public OriginalTextLimits getData() {
            return data;
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    @Required
    public void setDirectOriginalTextService(DirectOriginalTextService directOriginalTextService) {
        this.directOriginalTextService = directOriginalTextService;
    }
}
