package ru.yandex.webmaster3.viewer.http.promo;

import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.abt.AbtService;
import ru.yandex.webmaster3.storage.abt.model.Experiment;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by Oleg Bazdyrev on 02/07/2018.
 * Общая ручка для получения всякого рода рекламных предложений (тизеров)
 */
@ReadAction
@Category("promo")
@Description("Получение тизеров для хоста")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetHostTeasersAction extends AbstractUserVerifiedHostAction<GetHostTeasersRequest, GetHostTeasersResponse> {

    private final AbtService abtService;
    private final List<AbstractHostTeaserProvider> providers;

    @Override
    public GetHostTeasersResponse process(GetHostTeasersRequest request) {
        // эксперименты хоста
        WebmasterHostId hostId = request.getHostId();
        Map<String, String> groupsByExperiment = abtService.getHostExperiments(hostId);

        List<AbstractHostTeaser> teasers = Collections.synchronizedList(new ArrayList<>());
        for (AbstractHostTeaserProvider provider : providers) {
            teasers.addAll(provider.createTeasers(hostId, groupsByExperiment));
        }
        return new GetHostTeasersResponse(teasers);
    }
}
