package ru.yandex.webmaster3.viewer.http.promo;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 02/07/2018.
 */
public enum HostTeaserType implements Discriminator<AbstractHostTeaser> {
    @Description("WMC-5607: Тизер для РСЯ")
    PARTNER(PartnerHostTeaser.class),
    TEST(TestHostTeaser.class),
    @Description("WMC-10784: Тизеры для маркета")
    MARKET_PROMO_TEASER(MarketPromoTeaser.class),
    @Description("WMC-12313: [Бэк] Показывать промо-блок ТВ на дашборде магазинам")
    NEW_STORES(NewStoresPromoTeaser.class),
    ;

    private final Class<? extends AbstractHostTeaser> dataClass;

    HostTeaserType(Class<? extends AbstractHostTeaser> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends AbstractHostTeaser> getDataClass() {
        return dataClass;
    }
}
