package ru.yandex.webmaster3.viewer.http.promo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.service.HostOwnerService;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.feeds.FeedsNative2YDao;
import ru.yandex.webmaster3.storage.host.service.CommercialOwnersService;

/**
 * WMC-12313: [Бэк] Показывать промо-блок ТВ на дашборде магазинам
 **/
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Slf4j
public class NewStoresPromoTeaserProvider implements AbstractHostTeaserProvider {

    private final CommercialOwnersService commercialOwnersService;
    private final FeedsNative2YDao feedsNative2YDao;
    private final HostOwnerService hostOwnerService;

    @Override
    public Collection<AbstractHostTeaser> createTeasers(WebmasterHostId hostId, Map<String, String> groupsByExperiments) {
        String owner = hostOwnerService.getHostOwner(WwwUtil.cutWWWAndM(hostId));
        String domain = WwwUtil.cutWWWAndM(hostId);
        if (commercialOwnersService.isCommercialOwner(IdUtils.urlToHostId(owner)) && !feedsNative2YDao.hasSuccessfulFeeds(domain)) {
            return List.of(new NewStoresPromoTeaser());
        }
        return List.of();
    }
}
