package ru.yandex.webmaster3.viewer.http.promo;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 02/07/2018.
 */
public class PartnerHostTeaser extends AbstractHostTeaser {

    private final Segment segment;
    private final Long predictedMonthReward;

    public PartnerHostTeaser(Segment segment, Long predictedMonthReward) {
        super(HostTeaserType.PARTNER);
        this.segment = segment;
        this.predictedMonthReward = predictedMonthReward;
    }

    @Description("Сегмент")
    public Segment getSegment() {
        return segment;
    }

    @Description("Прогноз дохода за месяц (только для новых)")
    public Long getPredictedMonthReward() {
        return predictedMonthReward;
    }

    public enum Segment {
        @Description("Чужие - есть монетизация от конкурентов")
        FOREIGN,
        @Description("Новые - нет монетизации (вариант 1)")
        NEW_1,
        @Description("Новые - нет монетизации (вариант 2)")
        NEW_2,
        @Description("Новые - нет монетизации (вариант 3)")
        NEW_3,
        ;
    }
}
