package ru.yandex.webmaster3.viewer.http.recommendations;


import lombok.AllArgsConstructor;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.concurrency.AsyncCtx;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.cache.dao.WidgetCacheYDao;
import ru.yandex.webmaster3.viewer.http.concurrency.AsyncAction;

/**
 * Created by shabashoff.
 */
@ReadAction
@Category("recommendations")
@Component("/widgets/get")
@AllArgsConstructor(onConstructor_ = @Autowired)
@Description("Получение инфы по виджетам")
public class GetWidgetsAction extends AsyncAction<GetWidgetRequest, GetWidgetsResponse> {
    private final WidgetInfoService widgetInfoService;
    private final WidgetCacheYDao widgetCacheYDao;

    @Override
    public GetWidgetsResponse processAsync(AsyncCtx ctx, GetWidgetRequest request) throws WebmasterException {
        WebmasterHostId hostId = request.getHostId();
        byte[] cacheData = widgetCacheYDao.getData(hostId);
        GetWidgetsResponse resp;

        if (cacheData != null) {
            resp = SerializationUtils.deserialize(cacheData);
            if (resp != null && resp.getRecommendations() != null) {
                widgetInfoService.fixEmailRecommendation(request.getUserId(), resp.getRecommendations());
            }
        } else {
            var widgets = widgetInfoService.getWidgetsAndRecommendations(ctx, hostId, request.getUserId());
            resp = new GetWidgetsResponse(widgets.getLeft(), widgets.getRight());
            widgetCacheYDao.saveData(hostId, SerializationUtils.serialize(resp));
        }

        return resp;
    }
}
