package ru.yandex.webmaster3.viewer.http.regions;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.regions.RegionUtils;
import ru.yandex.webmaster3.core.regions.W3RegionsTreeService;
import ru.yandex.webmaster3.viewer.http.searchquery.regions.RegionView;
import ru.yandex.webmaster3.viewer.http.searchquery.regions.RegionsTreeBuilder;
import ru.yandex.webmaster3.viewer.regions.SearchQueryRegionsIndexService;

/**
 * Created by Oleg Bazdyrev on 29/07/2021.
 */
@Slf4j
@ReadAction
@Category("regions")
@Component("/regions/getAll")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetAllRegionsAction extends Action<GetAllRegionsAction.Request, GetAllRegionsAction.Response> {

    private final SearchQueryRegionsIndexService searchQueryRegionsIndexService;
    private final W3RegionsTreeService w3regionsTreeService;

    @Override
    public Response process(Request request) throws WebmasterException {
        String filter = request.filter;
        if (filter != null) {
            filter = filter.trim().toLowerCase();
            if (StringUtils.isEmpty(filter)) {
                filter = null;
            }
        }
        RegionsTreeBuilder builder = new RegionsTreeBuilder(searchQueryRegionsIndexService, w3regionsTreeService, filter, request.regionId);
        w3regionsTreeService.getAllVisibleRegions(RegionUtils.VISIBLE_OR_WHOLE_WORLD_PREDICATE).forEach(r -> builder.addRegion(r.getId()));
        return new Response(builder.build());
    }

    @Setter(onMethod_ = @RequestQueryProperty)
    public static final class Request implements ActionRequest {
        int regionId = RegionUtils.WHOLE_WORLD_REGION.getId();
        String filter;
    }

    @Value
    public static final class Response implements ActionResponse.NormalResponse {
        List<RegionView> children;
    }
}
