package ru.yandex.webmaster3.viewer.http.regions;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.regions2.RegionView;

import java.util.List;

/**
 * @author avhaliullin
 */
public abstract class RegionInfoResponse implements ActionResponse {
    public static class NormalResponse extends RegionInfoResponse implements ActionResponse.NormalResponse {
        private final RegionView region;
        private final List<RegionView> parents;
        private final List<RegionView> children;
        private final List<RegionView> proposed;

        public NormalResponse(RegionView region, List<RegionView> parents, List<RegionView> children, List<RegionView> proposed) {
            this.region = region;
            this.parents = parents;
            this.children = children;
            this.proposed = proposed;
        }

        public RegionView getRegion() {
            return region;
        }

        public List<RegionView> getParents() {
            return parents;
        }

        public List<RegionView> getChildren() {
            return children;
        }

        public List<RegionView> getProposed() {
            return proposed;
        }
    }

    public static enum RegionInfoErrorType {
        REGION_INFO__UNKNOWN_REGION
    }

    @Description("Не найден регион с таким id")
    public static class UnknownRegionResponse extends RegionInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        private final int regionId;
        public UnknownRegionResponse(Class<?> clazz, int regionId) {
            this.clazz = clazz;
            this.regionId = regionId;
        }
        @Override public Enum<?> getCode() { return RegionInfoErrorType.REGION_INFO__UNKNOWN_REGION; }
        @Override public Class<?> getClazz() { return clazz; }

        public int getRegionId() {
            return regionId;
        }
    }
}
