package ru.yandex.webmaster3.viewer.http.regions;

import java.util.List;

import com.google.common.collect.Iterables;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.W3RegionInfo;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.regions.W3RegionsTreeService;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;
import ru.yandex.webmaster3.viewer.regions.RegionsIndexService;
import ru.yandex.webmaster3.viewer.regions.data.RegionWithParents;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Региональный саджест")
@Category("regions")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class RegionsSuggestAction extends BaseWebmaster3Action<RegionsSuggestRequest, RegionsSuggestResponse> {

    private final int MIN_PARENTS = 2;

    private final RegionsIndexService regionsIndexService;
    private final W3RegionsTreeService w3RegionsTreeService;

    @Override
    public RegionsSuggestResponse process(RegionsSuggestRequest request) throws WebmasterException {
        List<RegionWithParents> regions = regionsIndexService.searchRegions(request.getPrefix(), request.getLocale(), request.getLimit());
        // add more parents
        for (RegionWithParents region : regions) {
            int regionId = region.getParents().isEmpty() ? region.getId() : Iterables.getLast(region.getParents());
            while (region.getParents().size() < MIN_PARENTS) {
                W3RegionInfo parent = w3RegionsTreeService.getVisibleParent(regionId, RegionsIndexService.VISIBILITY_PREDICATE);
                if (parent == null) {
                    break;
                }
                region.getParents().add(parent.getId());
                regionId = parent.getId();
            }
        }
        return new RegionsSuggestResponse(regions);
    }
}
