package ru.yandex.webmaster3.viewer.http.regions;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.data.L10nEnum;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * @author avhaliullin
 */
public class RegionsSuggestRequest extends AbstractFrontendRequest {
    private String prefix = "";
    private L10nEnum locale;
    private int limit = 10;

    @Description("Префикс имени региона")
    @RequestQueryProperty
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Description("Локаль пользователя (используется при \"ранжировании\" результатов)")
    @RequestQueryProperty(required = true)
    public void setLocale(L10nEnum locale) {
        this.locale = locale;
    }

    public String getPrefix() {
        return prefix;
    }

    public L10nEnum getLocale() {
        return locale;
    }

    public int getLimit() {
        return limit;
    }

    @Description("Лимит количества результатов (на самом деле может вернуться больше - см. ивановка)")
    @RequestQueryProperty
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
