package ru.yandex.webmaster3.viewer.http.regions2;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author leonidrom
 */

@WriteAction
@Description("Отменить заявку на смену регионов хоста")
@Category("regions")
public class CancelHostRegionsModerationAction extends AbstractUserVerifiedHostAction<CancelHostRegionsModerationRequest, CancelHostRegionsModerationResponse> {
    private HostRegionsModerationService hostRegionsModerationService;

    @Override
    public CancelHostRegionsModerationResponse process(CancelHostRegionsModerationRequest request) {
        if (!hostRegionsModerationService.cancelModerationRequest(request.getHostId(), request.getRequestId())) {
            return new CancelHostRegionsModerationResponse.RequestExpiredResponse(getClass());
        } else {
            return new CancelHostRegionsModerationResponse.NormalResponse();
        }
    }

    @Required
    public void setHostRegionsModerationService(HostRegionsModerationService hostRegionsModerationService) {
        this.hostRegionsModerationService = hostRegionsModerationService;
    }
}
