package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author leonidrom
 */
public abstract class CancelHostRegionsModerationResponse implements ActionResponse {
    public static class NormalResponse extends CancelHostRegionsModerationResponse implements ActionResponse.NormalResponse {
    }

    public enum CancelHostRegionsModerationResponseEnum {
        CANCEL_HOST_REGIONS_MODERATION__REQUEST_EXPIRED,
    }

    public static abstract class CancelHostRegionsModerationErrorResponse extends CancelHostRegionsModerationResponse implements ActionResponse.ErrorResponse{
        private final Class<?> clazz;
        private final CancelHostRegionsModerationResponseEnum code;
        public CancelHostRegionsModerationErrorResponse(Class<?> clazz, CancelHostRegionsModerationResponseEnum code) {
            this.clazz = clazz;
            this.code = code;
        }

        @Override public Enum<?> getCode() { return code; }
        @Override public Class<?> getClazz() { return clazz; }
    }

    @Description("Заявку с этим requestId уже нельзя отменить")
    public static class RequestExpiredResponse extends CancelHostRegionsModerationErrorResponse {
        public RequestExpiredResponse(Class<?> clazz) { super(clazz, CancelHostRegionsModerationResponseEnum.CANCEL_HOST_REGIONS_MODERATION__REQUEST_EXPIRED); }
    }
}
