package ru.yandex.webmaster3.viewer.http.regions2;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.regions.W3RegionsTreeService;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.HashSet;
import java.util.Set;

/**
 * @author leonidrom
 */

@WriteAction
@Description("Создать заявку на смену регионов хоста")
@Category("regions")
@Slf4j
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ChangeHostRegionsAction extends AbstractUserVerifiedHostAction<ChangeHostRegionsRequest, ChangeHostRegionsResponse> {

    private final HostRegionsModerationService hostRegionsModerationService;
    private final W3RegionsTreeService w3regionsTreeService;

    @Override
    public ChangeHostRegionsResponse process(ChangeHostRegionsRequest request) {

        WebmasterHostId evidenceHost = IdUtils.urlToHostId(request.getEvidence());
        if (!request.getHostId().equals(evidenceHost)) {
            return new ChangeHostRegionsResponse.InvalidEvidenceResponse(getClass());
        }

        // TODO: check for 'no region' with other regions
        Set<Integer> regions = new HashSet<>(request.getWebmasterRegions());
        for (int regionId: regions) {
            if (w3regionsTreeService.getExactRegionInfo(regionId) == null) {
                return new ChangeHostRegionsResponse.UnknownRegionResponse(getClass(), regionId);
            }
        }

        HostRegionsModerationService.AddRequestStatus result = hostRegionsModerationService.createModerationRequest(
                request.getHostId(), regions, request.getEvidence().toExternalForm());

        if (result == HostRegionsModerationService.AddRequestStatus.ALREADY_HAS_REQUEST) {
            return new ChangeHostRegionsResponse.AlreadyHaveModerationRequestResponse(getClass());
        } else {
            return new ChangeHostRegionsResponse.NormalResponse();
        }
    }
}

