package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.net.URL;
import java.util.List;

/**
 * @author leonidrom
 */
public class ChangeHostRegionsRequest extends AbstractUserVerifiedHostRequest {
    private List<Integer> webmasterRegions;
    private URL evidence;

    public List<Integer> getWebmasterRegions() {
        return webmasterRegions;
    }

    @Description("Список из id новых регионов в Вебмастере")
    @RequestQueryProperty(required = true)
    public void setRegionId(List<Integer> webmasterRegions) {
        this.webmasterRegions = webmasterRegions;
    }

    public URL getEvidence() {
        return evidence;
    }

    @Description("URL страницы, подтверждающей принадлежность сайта к регионам")
    @RequestQueryProperty(required = true)
    public void setEvidence(URL evidence) {
        this.evidence = evidence;
    }
}
