package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author leonidrom
 */
public abstract class ChangeHostRegionsResponse implements ActionResponse {
    public static class NormalResponse extends ChangeHostRegionsResponse implements ActionResponse.NormalResponse{
    }

    public enum ChangeHostRegionsResponseEnum {
        CHANGE_HOST_REGIONS__ALREADY_HAS_MODERATION_REQUEST,
        CHANGE_HOST_REGIONS__INVALID_EVIDENCE,
        CHANGE_HOST_REGIONS__UNKNOWN_REGION
    }

    public static abstract class ChangeHostRegionsErrorResponse extends ChangeHostRegionsResponse implements ActionResponse.ErrorResponse{
        private final Class<?> clazz;
        private final ChangeHostRegionsResponseEnum code;
        public ChangeHostRegionsErrorResponse(Class<?> clazz, ChangeHostRegionsResponseEnum code) {
            this.clazz = clazz;
            this.code = code;
        }

        @Override public Enum<?> getCode() { return code; }
        @Override public Class<?> getClazz() { return clazz; }
    }

    @Description("Для хоста уже есть заявка на модерацию регионов")
    public static class AlreadyHaveModerationRequestResponse extends ChangeHostRegionsErrorResponse {
        public AlreadyHaveModerationRequestResponse(Class<?> clazz) {
            super(clazz, ChangeHostRegionsResponseEnum.CHANGE_HOST_REGIONS__ALREADY_HAS_MODERATION_REQUEST);
        }
    }

    @Description("Ссылка, подтверждающая принадлежность регионам, не принадлежит хосту")
    public static class InvalidEvidenceResponse extends ChangeHostRegionsErrorResponse {
        public InvalidEvidenceResponse(Class<?> clazz) {
            super(clazz, ChangeHostRegionsResponseEnum.CHANGE_HOST_REGIONS__INVALID_EVIDENCE);
        }
    }

    @Description("Не найден регион с таким id")
    public static class UnknownRegionResponse extends ChangeHostRegionsErrorResponse {
        private final int regionId;

        public UnknownRegionResponse(Class<?> clazz, int regionId) {
            super(clazz, ChangeHostRegionsResponseEnum.CHANGE_HOST_REGIONS__UNKNOWN_REGION);
            this.regionId = regionId;
        }

        public int getRegionId() {
            return regionId;
        }
    }
}
