package ru.yandex.webmaster3.viewer.http.regions2;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author leonidrom
 */

@WriteAction
@Description("Скрыть сообщение о модерации")
@Category("regions")
public class HideHostRegionsModerationAction extends AbstractUserVerifiedHostAction<HideHostRegionsModerationRequest, HideHostRegionsModerationResponse> {
    private HostRegionsModerationService hostRegionsModerationService;

    @Override
    public HideHostRegionsModerationResponse process(HideHostRegionsModerationRequest request) {
        hostRegionsModerationService.markModerationRequestAsHiddenFromUser(request.getHostId(), request.getRequestId());
        return new HideHostRegionsModerationResponse();
    }

    @Required
    public void setHostRegionsModerationService(HostRegionsModerationService hostRegionsModerationService) {
        this.hostRegionsModerationService = hostRegionsModerationService;
    }
}
