package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author leonidrom
 */
public abstract class HostRegionsInfoResponse implements ActionResponse {
    public static class NormalResponse extends HostRegionsInfoResponse implements ActionResponse.NormalResponse {
        private final int webmasterRegionsLimit;
        private final List<RegionView> directoryRegions;
        private final List<RegionWithParentsView> webmasterRegions;
        private final List<RegionView> pendingRegions;
        private final HostRegionsModerationView moderationInfo;

        public NormalResponse(int webmasterRegionsLimit,
                              List<RegionView> directoryRegions,
                              List<RegionWithParentsView> webmasterRegions,
                              List<RegionView> pendingRegions,
                              HostRegionsModerationView moderationInfo) {
            this.webmasterRegionsLimit = webmasterRegionsLimit;
            this.directoryRegions = directoryRegions;
            this.webmasterRegions = webmasterRegions;
            this.pendingRegions = pendingRegions;
            this.moderationInfo = moderationInfo;
        }

        @Description("Сколько всего вебмастерских регионов может быть у хоста")
        public int getWebmasterRegionsLimit() {
            return webmasterRegionsLimit;
        }

        public List<RegionView> getDirectoryRegions() {
            return directoryRegions;
        }

        public List<RegionWithParentsView> getWebmasterRegions() {
            return webmasterRegions;
        }

        @Description("null, если заявок на модерацию нет")
        public HostRegionsModerationView getModerationInfo() {
            return moderationInfo;
        }

        @Description("Промодерированные регионы, отгружаются в поиск")
        public List<RegionView> getPendingRegions() {
            return pendingRegions;
        }
    }

    public enum HostRegionsInfoErrorType {
        HOST_REGIONS_INFO__NO_REGIONS_INFO
    }

    @Description("Регион вместе со списком его родителей")
    public static class RegionWithParentsView extends RegionView {
        private final List<RegionView> parents;

        public RegionWithParentsView(int id, List<RegionView> parents) {
            super(id);
            this.parents = new ArrayList<>(parents);
        }

        @Description("Родители в порядке от младшего к старшему")
        public List<RegionView> getParents() {
            return parents;
        }
    }

    @Description("Информация о регионах хоста отсутствует")
    public static class NoInfoResponse extends HostRegionsInfoResponse implements ActionResponse.ErrorResponse{
        private final Class<?> clazz;
        public NoInfoResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override public Enum<?> getCode() { return HostRegionsInfoErrorType.HOST_REGIONS_INFO__NO_REGIONS_INFO; }
        @Override public Class<?> getClazz() { return clazz; }
        @Override public String getMessage() { return "There is no regions info available for host"; }
    }
}
