package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @author leonidrom
 */
public class HostRegionsModerationView {
    private final UUID requestId;
    private final HostRegionsModerationStatus status;

    // Регионы в процессе модерации
    private final List<RegionView> regions;

    // Либо, если модерация завершена, принятые и непринятые регионы.
    private final List<RegionView> acceptedRegions;
    private final List<RegionView> rejectedRegions;
    private final boolean isFullyRejected;

    HostRegionsModerationView(HostRegionsModerationStatus status, Collection<Integer> regions, UUID requestId) {
        this.status = status;
        this.regions = regions.stream().map(RegionView::new).collect(Collectors.toList());
        this.acceptedRegions = null;
        this.rejectedRegions = null;
        this.isFullyRejected = false;
        this.requestId = requestId;
    }

    HostRegionsModerationView(HostRegionsModerationStatus status,
                              Collection<Integer> acceptedRegions, Collection<Integer> rejectedRegions,
                              UUID requestId) {
        this.status = status;
        this.regions = null;
        this.acceptedRegions = acceptedRegions.stream().map(RegionView::new).collect(Collectors.toList());
        this.rejectedRegions = rejectedRegions.stream().map(RegionView::new).collect(Collectors.toList());
        this.isFullyRejected = acceptedRegions.isEmpty();
        this.requestId = requestId;
    }

    @Description("Регионы в процессе модерации")
    public List<RegionView> getRegions() {
        return regions;
    }

    @Description("Принятые регионы для случая обработанной заявки")
    public List<RegionView> getAcceptedRegions() {
        return acceptedRegions;
    }

    @Description("Непринятые регионы для случая обработанной заявки")
    public List<RegionView> getRejectedRegions() {
        return rejectedRegions;
    }

    @Description("true, если заявка была полностью отклонена")
    public boolean isFullyRejected() {
        return isFullyRejected;
    }

    public HostRegionsModerationStatus getStatus() {
        return status;
    }

    public UUID getRequestId() {
        return requestId;
    }
}
