package ru.yandex.webmaster3.viewer.http.regions2;

/**
 * @author leonidrom
 */

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

@WriteAction
@Description("Создать заявку на сброс региона хоста")
@Category("regions")
public class ResetHostRegionsAction extends AbstractUserVerifiedHostAction<ResetHostRegionsRequest, ResetHostRegionsResponse> {

    private HostRegionsModerationService hostRegionsModerationService;

    @Override
    public ResetHostRegionsResponse process(ResetHostRegionsRequest request) {
        HostRegionsModerationService.AddRequestStatus result = hostRegionsModerationService.createModerationRequest(
                request.getHostId(), HostRegionsModerationService.NOT_SPECIFIED_REGION_SET, null);

        if (result == HostRegionsModerationService.AddRequestStatus.ALREADY_HAS_REQUEST) {
            return new ResetHostRegionsResponse.AlreadyHaveModerationRequestResponse(getClass());
        } else {
            return new ResetHostRegionsResponse.NormalResponse();
        }
    }

    @Required
    public void setHostRegionsModerationService(HostRegionsModerationService hostRegionsModerationService) {
        this.hostRegionsModerationService = hostRegionsModerationService;
    }
}
