package ru.yandex.webmaster3.viewer.http.regions2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author leonidrom
 */
public abstract class ResetHostRegionsResponse implements ActionResponse {
    public static class NormalResponse extends ResetHostRegionsResponse implements ActionResponse.NormalResponse {
    }

    public enum ResetHostRegionsResponseEnum {
        RESET_HOST_REGION__ALREADY_HAS_MODERATION_REQUEST,
    }

    public static abstract class ResetHostRegionsErrorResponse extends ResetHostRegionsResponse implements ActionResponse.ErrorResponse{
        private final Class<?> clazz;
        private final ResetHostRegionsResponseEnum code;
        public ResetHostRegionsErrorResponse(Class<?> clazz, ResetHostRegionsResponseEnum code) {
            this.clazz = clazz;
            this.code = code;
        }

        @Override public Enum<?> getCode() { return code; }
        @Override public Class<?> getClazz() { return clazz; }
    }

    @Description("Для хоста уже есть заявка на модерацию региона")
    public static class AlreadyHaveModerationRequestResponse extends ResetHostRegionsErrorResponse {
        public AlreadyHaveModerationRequestResponse(Class<?> clazz) { super(clazz, ResetHostRegionsResponseEnum.RESET_HOST_REGION__ALREADY_HAS_MODERATION_REQUEST); }
    }
}
