package ru.yandex.webmaster3.viewer.http.request;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.UserAddedHost;
import ru.yandex.webmaster3.core.http.request.AddedHostIdAware;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class AbstractUserAddedHostRequest extends AbstractUserRequest implements AddedHostIdAware {
    private String hostIdString;
    private WebmasterHostId hostId;
    private UserAddedHost userAddedHost;

    @Override
    public void setHostId(String hostId) {
        this.hostIdString = hostId;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public void setConvertedHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    @Override
    public String getHostIdString() {
        return hostIdString;
    }

    @Override
    public UserAddedHost getUserAddedHost() {
        return userAddedHost;
    }

    @Override
    public void setUserAddedHost(UserAddedHost userAddedHost) {
        this.userAddedHost = userAddedHost;
    }
}
