package ru.yandex.webmaster3.viewer.http.request;

import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.storage.user.message.MessageId;

import java.lang.reflect.Type;

/**
 * @author avhaliullin
 */
public class MessageIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        if (toType.equals(MessageId.class)) {
            return MessageId.fromString(value);
        }
        return null;
    }

    @Override
    public ValueType describeType(Type type) {
        return ValueType.STRING;
    }
}
