package ru.yandex.webmaster3.viewer.http.robotstxt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.robotstxt.AnalyzeRobotsTxtService;
import ru.yandex.webmaster3.storage.robotstxt.exception.AnalisisRobotsTxtException;
import ru.yandex.webmaster3.storage.robotstxt.exception.AnalisisRobotsTxtHttpResponseException;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtErrorType;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtInputData;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtResult;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;

/**
 * User: azakharov
 * Date: 17.06.14
 * Time: 17:33
 *
 * @modified: ishalaru
 * Date: 20.05.2019
 */
@ReadAction
@Description(value = "Анализатор robots.txt")
@Category("robotstxt")
public class AnalyzeRobotsTxtAction extends BaseWebmaster3Action<AnalyzeRobotsTxtRequest, AnalyzeRobotsTxtResponse> {
    private static final Logger log = LoggerFactory.getLogger(AnalyzeRobotsTxtAction.class);

    private AnalyzeRobotsTxtService analyzeRobotsTxtService;

    @Override
    public AnalyzeRobotsTxtResponse process(AnalyzeRobotsTxtRequest request) throws WebmasterException {
        try {
            AnalyzeRobotsTxtResult result = analyzeRobotsTxtService.process(request.create());

            AnalyzeRobotsTxtResponse analyzeRobotsTxtResponse = new AnalyzeRobotsTxtResponse.NormalResponse(result.getRobotsTxtContent(),
                    result.getParseErrors(),
                    result.getAcceptedLines(),
                    result.getAllowInfos());

            return analyzeRobotsTxtResponse;
        } catch (AnalisisRobotsTxtHttpResponseException exp) {
            return new AnalyzeRobotsTxtResponse.MainHttpCodeResponse(analyzeRobotsTxtService.getClass(), exp.getError(), exp.getHttpResponse());
        } catch (AnalisisRobotsTxtException exp) {
            return new AnalyzeRobotsTxtResponse.MainErrorResponse(analyzeRobotsTxtService.getClass(), exp.getError());
        }
    }

    public void setAnalyzeRobotsTxtService(AnalyzeRobotsTxtService analyzeRobotsTxtService) {
        this.analyzeRobotsTxtService = analyzeRobotsTxtService;
    }
}
