package ru.yandex.webmaster3.viewer.http.robotstxt;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.worker.task.robotstxt.AnalyzeRobotTxtTaskData;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtInputData;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

import java.util.UUID;

/**
 * User: azakharov
 * Date: 17.06.14
 * Time: 17:35
 */
public class AnalyzeRobotsTxtRequest extends AbstractFrontendRequest {
    private String robotsTxtContent;
    private String hostName;
    private boolean loadOnly = false;
    private String urls;

    public String getRobotsTxtContent() {
        return robotsTxtContent;
    }

    @Description(value = "Содержимое файла robotsTxt")
    @RequestQueryProperty
    public void setRobotsTxtContent(String robotsTxtContent) {
        this.robotsTxtContent = robotsTxtContent;
    }

    public String getHostName() {
        return hostName;
    }

    @Description(value = "Имя хоста")
    @RequestQueryProperty
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isLoadOnly() {
        return loadOnly;
    }

    @Description(value = "Только загрузить содержимое файла или загрузить и анализировать")
    @RequestQueryProperty
    public void setLoadOnly(boolean loadOnly) {
        this.loadOnly = loadOnly;
    }

    @Description(value = "space-, tab- or newline-separated list of urls")
    @RequestQueryProperty
    public void setUrls(String urls) {
        this.urls = urls;
    }

    public String[] getUrlsAsArray() {
        if (StringUtils.isEmpty(urls)) {
            return new String[0];
        }
        return urls.split("[ \\t\\n\\f\\r]+");
    }

    public AnalyzeRobotsTxtInputData create() {
        return new AnalyzeRobotsTxtInputData(robotsTxtContent, hostName, loadOnly, urls);
    }

    public AnalyzeRobotTxtTaskData create(UUID taskId) {
        return new AnalyzeRobotTxtTaskData(taskId, robotsTxtContent, hostName, loadOnly, urls);
    }
}
