package ru.yandex.webmaster3.viewer.http.robotstxt;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtErrorType;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtResult;
import ru.yandex.webmaster3.storage.robotstxt.model.RobotsTxtUrlAllowInfo;

/**
 * User: azakharov
 * Date: 17.06.14
 * Time: 17:35
 */
public abstract class AnalyzeRobotsTxtResponse implements ActionResponse {
    public static class NormalResponse extends AnalyzeRobotsTxtResponse implements ActionResponse.NormalResponse {
        private final String robotsTxtContent;
        private final List<AnalyzeRobotsTxtResult.RobotsTxtErrorInfo> parseErrors;
        private final List<AnalyzeRobotsTxtResult.RobotsTxtSection> acceptedLines;
        private final List<RobotsTxtUrlAllowInfo> allowInfos;

        public NormalResponse(String robotsTxtContent,
                              List<AnalyzeRobotsTxtResult.RobotsTxtErrorInfo> parseErrors, List<AnalyzeRobotsTxtResult.RobotsTxtSection> acceptedLines,
                              List<RobotsTxtUrlAllowInfo> allowInfos)
        {
            this.robotsTxtContent = robotsTxtContent;
            this.parseErrors = parseErrors;
            this.acceptedLines = acceptedLines;
            this.allowInfos = allowInfos;
        }

        public NormalResponse(final String robotsTxtContent) {
            this(robotsTxtContent, null, null, null);
        }

        public String getRobotsTxtContent() {
            return robotsTxtContent;
        }

        public List<AnalyzeRobotsTxtResult.RobotsTxtErrorInfo> getParseErrors() {
            return parseErrors;
        }

        public List<RobotsTxtUrlAllowInfo> getAllowInfos() {
            return allowInfos;
        }

        public List<AnalyzeRobotsTxtResult.RobotsTxtSection> getAcceptedLines() {
            return acceptedLines;
        }
    }


    private static abstract class BaseErrorResponse extends AnalyzeRobotsTxtResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        public BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class MainErrorResponse extends BaseErrorResponse{
        private final AnalyzeRobotsTxtErrorType errorType;

        public MainErrorResponse(Class<?> clazz,AnalyzeRobotsTxtErrorType errorType) {
            super(clazz);
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {return errorType;}

        @Override
        public String getMessage() {return errorType.getErrorDescription();}
    }

    public static class MainHttpCodeResponse extends MainErrorResponse{
        private final HttpResponsePart httpResponse;
        public MainHttpCodeResponse(Class<?> clazz, AnalyzeRobotsTxtErrorType errorType, HttpResponsePart httpResponse) {
            super(clazz, errorType);
            this.httpResponse = httpResponse;
        }

        public HttpResponsePart getHttpResponse() {
            return httpResponse;
        }
    }

    public static class UnableToDownloadRobotsTxtResponse extends BaseErrorResponse {
        public UnableToDownloadRobotsTxtResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__UNABLE_TO_DOWNLOAD_ROBOTS_TXT;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__UNABLE_TO_DOWNLOAD_ROBOTS_TXT.getErrorDescription();}
    }

    public static class IllegalHttpCodeResponse extends BaseErrorResponse{
        private final HttpResponsePart httpResponse;
        public IllegalHttpCodeResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__ILLEGAL_HTTP_CODE;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__ILLEGAL_HTTP_CODE.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class RedirectNotSupportedResponse extends BaseErrorResponse {
        private final HttpResponsePart httpResponse;
        public RedirectNotSupportedResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__REDIRECT_NOT_SUPPORTED;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__REDIRECT_NOT_SUPPORTED.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class EmptyRobotsTxtResponse extends BaseErrorResponse {
        private final HttpResponsePart httpResponse;
        public EmptyRobotsTxtResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__EMPTY_ROBOTS_TXT;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__EMPTY_ROBOTS_TXT.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class TooManyUrlsResponse extends BaseErrorResponse {
        public TooManyUrlsResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__TOO_MANY_URLS;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__TOO_MANY_URLS.getErrorDescription();}
    }

}
