package ru.yandex.webmaster3.viewer.http.robotstxt;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.robotstxt.RobotsTxtService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;


/**
 * WMC-6417
 * @author akhazhoyan 11/2018
 */
@Category("robotstxt")
@Description("Получить robots.txt, который робот скачал в данное время с данного хоста")
@ReadAction
public final class GetRobotsTxtContentAction
        extends AbstractUserVerifiedHostAction<GetRobotsTxtContentAction.Req, GetRobotsTxtContentAction.Res> {

    private final RobotsTxtService robotsTxtService;

    @Autowired
    public GetRobotsTxtContentAction(RobotsTxtService robotsTxtService) {
        this.robotsTxtService = robotsTxtService;
    }

    @Override
    public Res process(Req request) {
        String nullableContent = robotsTxtService
                .getRobotsTxtContent(request.getHostId(), request.timestampMillis);
        return new Res(nullableContent);
    }

    public static class Req extends AbstractUserVerifiedHostRequest {
        private long timestampMillis;

        @RequestQueryProperty(value = "timestampMillis", required = true)
        public void setTimestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
        }
    }


    public static class Res implements ActionResponse.NormalResponse {
        private final String content;

        public Res(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }
    }
}
