package ru.yandex.webmaster3.viewer.http.robotstxt;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.robotstxt.RobotsTxtService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.List;


/**
 * WMC-6417
 * @author akhazhoyan 11/2018
 */
@Category("robotstxt")
@Description("Получить список дат, когда мы скачивали новые версии robots.txt с данного хоста")
@ReadAction
public final class GetRobotsTxtHistoryAction
        extends AbstractUserVerifiedHostAction<GetRobotsTxtHistoryAction.Req, GetRobotsTxtHistoryAction.Res> {

    private final RobotsTxtService robotsTxtService;

    @Autowired
    public GetRobotsTxtHistoryAction(RobotsTxtService robotsTxtService) {
        this.robotsTxtService = robotsTxtService;
    }

    @Override
    public Res process(Req request) {
        return new Res(robotsTxtService.getRobotsTxtTimestampsMillis(request.getHostId()));
    }

    public static class Req extends AbstractUserVerifiedHostRequest {
    }

    public static class Res implements ActionResponse.NormalResponse {
        private final List<Long> timestampsMillis;

        public Res(List<Long> timestampsMillis) {
            this.timestampsMillis = timestampsMillis;
        }

        public List<Long> getTimestampsMillis() {
            return timestampsMillis;
        }
    }
}
