package ru.yandex.webmaster3.viewer.http.robotstxt.model;

import java.util.List;

import lombok.Value;

import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtErrorType;
import ru.yandex.webmaster3.storage.robotstxt.model.AnalyzeRobotsTxtResult;
import ru.yandex.webmaster3.storage.robotstxt.model.RobotsTxtUrlAllowInfo;
import ru.yandex.webmaster3.viewer.http.async.model.BaseAsyncInfoErrorType;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public abstract class AnalyzeRobotsTxtInfoResponse implements ActionResponse {
    @Value
    public static class NormalResponse extends AnalyzeRobotsTxtInfoResponse implements ActionResponse.NormalResponse {
        String robotsTxtContent;
        List<AnalyzeRobotsTxtResult.RobotsTxtErrorInfo> parseErrors;
        List<AnalyzeRobotsTxtResult.RobotsTxtSection> acceptedLines;
        List<RobotsTxtUrlAllowInfo> allowInfos;
        boolean inProgress;

        public static AnalyzeRobotsTxtInfoResponse.NormalResponse stillInProgress() {
            return new AnalyzeRobotsTxtInfoResponse.NormalResponse(null, null, null, null, true);
        }
    }


    private static abstract class BaseErrorResponse extends AnalyzeRobotsTxtInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        public BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class AnalyzeRobotsTxtInfoErrorResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        private final AnalyzeRobotsTxtErrorType errorType;

        public AnalyzeRobotsTxtInfoErrorResponse(Class<?> clazz, AnalyzeRobotsTxtErrorType errorType) {
            super(clazz);
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {return errorType;}

        @Override
        public String getMessage() {return errorType.getErrorDescription();}
    }

    public static class RequestIdNotFound extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        public RequestIdNotFound(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_NOT_FOUND;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_NOT_FOUND.getErrorDescription();}
    }

    @Deprecated
    public static class RequestStillInProgress extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        public RequestStillInProgress(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_STILL_IN_PROGRESS;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_STILL_IN_PROGRESS.getErrorDescription();}
    }

    public static class RequestFailed extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        public RequestFailed(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_FAILED;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_FAILED.getErrorDescription();}
    }

    public static class ResponseDataCorrupted extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse{
        public ResponseDataCorrupted(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__DATA_CORRUPTED;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__DATA_CORRUPTED.getErrorDescription();}
    }


    public static class AnalyzeRobotsTxtInfoHttpCodeResponse extends AnalyzeRobotsTxtInfoErrorResponse {
        private final HttpResponsePart httpResponse;
        public AnalyzeRobotsTxtInfoHttpCodeResponse(Class<?> clazz, AnalyzeRobotsTxtErrorType errorType, HttpResponsePart httpResponse) {
            super(clazz, errorType);
            this.httpResponse = httpResponse;
        }

        public HttpResponsePart getHttpResponse() {
            return httpResponse;
        }
    }

    public static class UnableToDownloadRobotsTxtResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        public UnableToDownloadRobotsTxtResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__UNABLE_TO_DOWNLOAD_ROBOTS_TXT;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__UNABLE_TO_DOWNLOAD_ROBOTS_TXT.getErrorDescription();}
    }

    public static class IllegalHttpCodeResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        private final HttpResponsePart httpResponse;
        public IllegalHttpCodeResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__ILLEGAL_HTTP_CODE;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__ILLEGAL_HTTP_CODE.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class RedirectNotSupportedResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        private final HttpResponsePart httpResponse;
        public RedirectNotSupportedResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__REDIRECT_NOT_SUPPORTED;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__REDIRECT_NOT_SUPPORTED.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class EmptyRobotsTxtResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        private final HttpResponsePart httpResponse;
        public EmptyRobotsTxtResponse(Class<?> clazz, HttpResponsePart httpResponse) {
            super(clazz);
            this.httpResponse = httpResponse;
        }

        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__EMPTY_ROBOTS_TXT;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__EMPTY_ROBOTS_TXT.getErrorDescription();}
        public HttpResponsePart getHttpResponse() {return httpResponse;}
    }

    public static class TooManyUrlsResponse extends AnalyzeRobotsTxtInfoResponse.BaseErrorResponse {
        public TooManyUrlsResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__TOO_MANY_URLS;}
        @Override public String getMessage() {return AnalyzeRobotsTxtErrorType.ANALYZE_ROBOTSTXT__TOO_MANY_URLS.getErrorDescription();}
    }
}
