package ru.yandex.webmaster3.viewer.http.robotstxt.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.sitemap.analyze.model.StartSitemapAnalyzeErrorTypes;
import ru.yandex.webmaster3.viewer.http.sitemap.analyze.model.StartSitememapAnalyzeResponse;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public abstract class StartAnalyzeRobotsTxtResponse implements ActionResponse {
    public static class NormalResponse extends StartAnalyzeRobotsTxtResponse implements ActionResponse.NormalResponse {
        private final UUID requestId;

        public NormalResponse(UUID requestId) {
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }
    }

    public static abstract class AbstractErrorResponse extends StartSitememapAnalyzeResponse implements ActionResponse.ErrorResponse {
        private final StartSitemapAnalyzeErrorTypes errorType;

        public AbstractErrorResponse(StartSitemapAnalyzeErrorTypes errorType) {
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }
    }

    public static class UniversalResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {

        public UniversalResponse(StartSitemapAnalyzeErrorTypes errorType) {
            super(errorType);
        }
    }
}
