package ru.yandex.webmaster3.viewer.http.search;

import org.joda.time.Instant;

import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.RequestId;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;

/**
 * @author aherman
 */
public class GetSearchBaseUpdatesRequest implements ActionRequest, RequestIdAware {
    private RequestId requestId;
    private Instant switchedFrom;
    private Instant switchedTo;
    private Instant collectedFrom;
    private Instant collectedTo;

    @Override
    public void setBalancerRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    @Override
    public RequestId getBalancerRequestId() {
        return requestId;
    }

    public Instant getSwitchedFrom() {
        return switchedFrom;
    }

    @RequestQueryProperty
    public void setSwitchedFrom(Instant switchedFrom) {
        this.switchedFrom = switchedFrom;
    }

    public Instant getSwitchedTo() {
        return switchedTo;
    }

    @RequestQueryProperty
    public void setSwitchedTo(Instant switchedTo) {
        this.switchedTo = switchedTo;
    }

    public Instant getCollectedFrom() {
        return collectedFrom;
    }

    @RequestQueryProperty
    public void setCollectedFrom(Instant collectedFrom) {
        this.collectedFrom = collectedFrom;
    }

    public Instant getCollectedTo() {
        return collectedTo;
    }

    @RequestQueryProperty
    public void setCollectedTo(Instant collectedTo) {
        this.collectedTo = collectedTo;
    }
}
