package ru.yandex.webmaster3.viewer.http.search;

import java.util.List;

import org.joda.time.Instant;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class GetSearchBaseUpdatesResponse implements ActionResponse {
    public static class NormalResponse extends GetSearchBaseUpdatesResponse implements ActionResponse.NormalResponse {
        private final List<BaseInfo> bases;

        public NormalResponse(List<BaseInfo> bases) {
            this.bases = bases;
        }

        public List<BaseInfo> getBases() {
            return bases;
        }
    }

    public static class BaseInfo {
        private final Instant switchDate;
        private final Instant collectionDate;

        public BaseInfo(Instant collectionDate, Instant switchDate) {
            this.switchDate = switchDate;
            this.collectionDate = collectionDate;
        }

        public Instant getSwitchDate() {
            return switchDate;
        }

        public Instant getCollectionDate() {
            return collectionDate;
        }
    }
}
