package ru.yandex.webmaster3.viewer.http.search;

import java.io.Serializable;
import java.util.Map;

import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.achievements.model.AchievementInfo;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;
import ru.yandex.webmaster3.storage.host.HostIndicatorsState;

/**
 * Created by shabashoff.
 */
@Data
@NoArgsConstructor
public class GetSearchSiteDisplayResponse implements ActionResponse.NormalResponse , Serializable {
    private Map<AchievementType, AchievementInfo> achievements;
    private HostIndicatorsState hostPages;

    /* Флажки Alert потому что они инвертируют логику. То есть,
    если faviconAlert = true, то значит на фронте не будет галочки, иначе -- будет
     */
    private int turboTraffic;
    private boolean companyAlert;
    private Boolean faviconAlert;
    private Boolean titleAlert;
    private Boolean descriptionAlert;
    private Boolean turboAlert;
    private Boolean newsAlert;
    private Boolean picAlert;
    private Boolean serpLink; // это на самом деле по логике serpLinkAlert
    private Boolean ymlSnippetAlert;
    private Boolean greenUrls; // надо выпилить
    private Boolean greenUrlsAlert;
    private Boolean qaAlert;

    private TurboListingAlert turboListingAlert = TurboListingAlert.NONE;
    private TurboYmlAlert turboYmlAlert = TurboYmlAlert.NONE;
    private TurboRssAlert turboRssAlert = TurboRssAlert.NONE;
    private YmlSnippetStatus ymlSnippetStatus = YmlSnippetStatus.NOT_SHOP;

    enum TurboListingAlert {
        OK, NONE, DIAGNOSTIC_ALERT, LISTING_OFF
    }

    enum TurboYmlAlert {
        OK, NONE, YML_OFF, CART_DISABLED
    }

    enum TurboRssAlert {
        OK, NONE, RSS_OFF
    }

    enum YmlSnippetStatus {
        @Description("Не магазин - неприменимо")
        NOT_SHOP,
        @Description("Сниппет есть")
        ON,
        @Description("Сниппета нет")
        OFF
    }

}
