package ru.yandex.webmaster3.viewer.http.searchquery;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.searchquery.QueryGroupId;
import ru.yandex.webmaster3.storage.searchquery.QueryGroupService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@WriteAction
@Category("searchquery")
@Component("/searchquery/group/delete")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class DeleteQueryGroupAction extends AbstractUserVerifiedHostAction<DeleteQueryGroupRequest, DeleteQueryGroupResponse> {
    private final QueryGroupService queryGroupService;

    @Override
    public DeleteQueryGroupResponse process(DeleteQueryGroupRequest request) {
        UUID groupId = request.getGroupId();
        QueryGroupId queryGroupId = new QueryGroupId(request.getHostId(), groupId);
        queryGroupService.deleteGroup(queryGroupId);
        return new DeleteQueryGroupResponse.NormalResponse();
    }
}
