package ru.yandex.webmaster3.viewer.http.searchquery;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public abstract class GetHostSearchHistoryResponse implements DateHistory<QueryIndicator>, ActionResponse {
    public static class NormalResponse extends GetHostSearchHistoryResponse implements ActionResponse.NormalResponse {
        private final List<SearchHistory> history;

        public NormalResponse(List<SearchHistory> history) {
            this.history = history;
        }

        @Override
        public List<? extends History<QueryIndicator>> getHistories() {
            return history;
        }
    }

    public static class SearchHistory implements DateHistory.History<QueryIndicator> {
        private final QueryIndicator indicatorName;
        private final List<DatePoint> data;

        public SearchHistory(QueryIndicator indicatorName, List<DatePoint> data) {
            this.indicatorName = indicatorName;
            this.data = data;
        }

        @Override
        public QueryIndicator getIndicatorName() {
            return indicatorName;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
